/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.CompileState;
import javax.media.j3d.FogRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.MultipleParentException;
import javax.media.j3d.NnuId;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Targets;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.View;
import javax.media.j3d.ViewSpecificGroupRetained;
import javax.media.j3d.VirtualUniverse;

class GroupRetained
extends NodeRetained
implements BHLeafInterface {
    ArrayList children = new ArrayList(1);
    Bounds collisionBound = null;
    Locale locale = null;
    ArrayList lights = null;
    ArrayList fogs = null;
    ArrayList modelClips = null;
    ArrayList altAppearances = null;
    boolean collisionTarget = false;
    ArrayList childrenSwitchLinks = null;
    int parentSwitchLinkChildIndex = -1;
    ArrayList orderedPaths = null;
    BoundingBox collisionVwcBounds;
    ArrayList mirrorGroup;
    HashKey key;
    GroupRetained sourceNode;
    BHLeafNode bhLeafNode = null;
    boolean isRoot = false;
    boolean allocatedLights = false;
    boolean allocatedFogs = false;
    boolean allocatedMclips = false;
    boolean allocatedAltApps = false;
    int scopingRefCount = 0;
    ArrayList compiledChildrenList = null;
    boolean isInClearLive = false;
    ArrayList viewLists = null;
    boolean inViewSpecificGroup = false;

    GroupRetained() {
        this.nodeType = 23;
        this.localBounds = new BoundingSphere();
        ((BoundingSphere)this.localBounds).setRadius(-1.0);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8256;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChild(Node node, int n2) {
        this.checkValidChild(node, "GroupRetained0");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doSetChild(node, n2);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doSetChild(node, n2);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doSetChild(Node node, int n2) {
        J3dMessage[] j3dMessageArray = null;
        int n3 = 0;
        int n4 = 0;
        NodeRetained nodeRetained = (NodeRetained)this.children.get(n2);
        if (this.source.isLive()) {
            if (nodeRetained != null) {
                n3 += 3;
                n4 = 3;
            }
            if (node != null) {
                n3 += 4;
            }
            j3dMessageArray = new J3dMessage[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                j3dMessageArray[i2] = new J3dMessage();
            }
        }
        if (nodeRetained != null) {
            nodeRetained.setParent(null);
            this.checkClearLive(nodeRetained, j3dMessageArray, 0, n2, null);
            if (this.source.isLive()) {
                this.universe.notifyStructureChangeListeners(false, (Object)this.source, (BranchGroup)nodeRetained.source);
            }
        }
        this.removeChildrenData(n2);
        if (node == null) {
            this.children.set(n2, null);
            if (j3dMessageArray != null) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
            return;
        }
        if (this.source.isLive()) {
            this.universe.notifyStructureChangeListeners(true, (Object)this.source, (BranchGroup)node);
        }
        NodeRetained nodeRetained2 = (NodeRetained)node.retained;
        nodeRetained2.setParent(this);
        this.children.set(n2, nodeRetained2);
        this.insertChildrenData(n2);
        this.checkSetLive(nodeRetained2, n2, j3dMessageArray, n4, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained2).isNew = true;
        }
        if (j3dMessageArray != null) {
            VirtualUniverse.mc.processMessage(j3dMessageArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertChild(Node node, int n2) {
        this.checkValidChild(node, "GroupRetained1");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.universe.notifyStructureChangeListeners(true, (Object)this.source, (BranchGroup)node);
                this.doInsertChild(node, n2);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doInsertChild(node, n2);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doInsertChild(Node node, int n2) {
        this.insertChildrenData(n2);
        for (int i2 = n2; i2 < this.children.size(); ++i2) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
            if (nodeRetained == null) continue;
            ++nodeRetained.childIndex;
        }
        if (node == null) {
            this.children.add(n2, null);
            return;
        }
        NodeRetained nodeRetained = (NodeRetained)node.retained;
        nodeRetained.setParent(this);
        this.children.add(n2, nodeRetained);
        this.checkSetLive(nodeRetained, n2, null, 0, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained).isNew = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(int n2) {
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n2);
                this.doRemoveChild(n2, null, 0);
                this.universe.setLiveState.clear();
                this.universe.notifyStructureChangeListeners(false, (Object)this.source, (BranchGroup)nodeRetained.source);
            }
            this.universe.waitForMC();
        } else {
            this.doRemoveChild(n2, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    int indexOfChild(Node node) {
        if (node != null) {
            return this.children.indexOf((NodeRetained)node.retained);
        }
        return this.children.indexOf(null);
    }

    void removeChild(Node node) {
        int n2 = this.indexOfChild(node);
        if (n2 >= 0) {
            this.removeChild(n2);
        }
    }

    void removeAllChildren() {
        int n2 = this.children.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.removeChild(i2);
        }
    }

    void doRemoveChild(int n2, J3dMessage[] j3dMessageArray, int n3) {
        NodeRetained nodeRetained = (NodeRetained)this.children.get(n2);
        int n4 = this.children.size();
        for (int i2 = n2; i2 < n4; ++i2) {
            NodeRetained nodeRetained2 = (NodeRetained)this.children.get(i2);
            if (nodeRetained2 == null) continue;
            --nodeRetained2.childIndex;
        }
        if (nodeRetained != null) {
            nodeRetained.setParent(null);
            this.checkClearLive(nodeRetained, j3dMessageArray, n3, n2, null);
        }
        this.children.remove(n2);
        this.removeChildrenData(n2);
        if (this.nodeType == 18) {
            SwitchRetained switchRetained = (SwitchRetained)this;
            switchRetained.setWhichChild(switchRetained.whichChild, true);
        }
    }

    Node getChild(int n2) {
        SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n2);
        if (sceneGraphObjectRetained == null) {
            return null;
        }
        return (Node)sceneGraphObjectRetained.source;
    }

    Enumeration getAllChildren() {
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.children.size());
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(i2);
            if (sceneGraphObjectRetained != null) {
                vector.add(sceneGraphObjectRetained.source);
                continue;
            }
            vector.add(null);
        }
        return vector.elements();
    }

    void checkValidChild(Node node, String string) {
        if (node != null && (node instanceof BranchGroup && ((BranchGroupRetained)node.retained).attachedToLocale || ((NodeRetained)node.retained).parent != null)) {
            throw new MultipleParentException(J3dI18N.getString(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(Node node) {
        this.checkValidChild(node, "GroupRetained2");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.universe.notifyStructureChangeListeners(true, (Object)this.source, (BranchGroup)node);
                this.doAddChild(node, null, 0);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doAddChild(node, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doAddChild(Node node, J3dMessage[] j3dMessageArray, int n2) {
        this.appendChildrenData();
        if (node == null) {
            this.children.add(null);
            return;
        }
        NodeRetained nodeRetained = (NodeRetained)node.retained;
        nodeRetained.setParent(this);
        this.children.add(nodeRetained);
        this.checkSetLive(nodeRetained, this.children.size() - 1, j3dMessageArray, n2, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained).isNew = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTo(BranchGroup branchGroup) {
        if (branchGroup != null) {
            ((GroupRetained)branchGroup.retained).dirtyBoundsCache();
        }
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                GroupRetained groupRetained = (GroupRetained)((BranchGroupRetained)branchGroup.retained).parent;
                this.doMoveTo(branchGroup);
                this.universe.setLiveState.clear();
                if (groupRetained == null) {
                    this.universe.notifyStructureChangeListeners(((BranchGroupRetained)branchGroup.retained).locale, (Object)this.source, branchGroup);
                } else {
                    this.universe.notifyStructureChangeListeners(groupRetained.source, (Object)this.source, branchGroup);
                }
            }
            this.universe.waitForMC();
        } else {
            this.doMoveTo(branchGroup);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doMoveTo(BranchGroup branchGroup) {
        int n2;
        J3dMessage[] j3dMessageArray = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (branchGroup != null) {
            BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
            GroupRetained groupRetained = (GroupRetained)branchGroupRetained.parent;
            if (groupRetained != null) {
                if (groupRetained.source.isLive()) {
                    n3 = 3;
                    n5 = 3;
                } else {
                    n3 = 0;
                    n5 = 0;
                }
            } else {
                n3 = 3;
                n5 = 3;
            }
            if (this.source.isLive()) {
                n3 += 4;
            }
            j3dMessageArray = new J3dMessage[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                j3dMessageArray[n2] = new J3dMessage();
                j3dMessageArray[n2].type = -1;
            }
            if (groupRetained == null) {
                if (branchGroupRetained.locale != null) {
                    branchGroupRetained.locale.doRemoveBranchGraph(branchGroup, j3dMessageArray, n4);
                }
            } else {
                groupRetained.doRemoveChild(groupRetained.children.indexOf(branchGroupRetained), j3dMessageArray, n4);
            }
        }
        this.doAddChild(branchGroup, j3dMessageArray, n5);
        if (n3 > 0) {
            int n6 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (j3dMessageArray[i2].type == -1) continue;
                ++n6;
            }
            if (n6 == n3) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            } else {
                J3dMessage[] j3dMessageArray2 = null;
                if (n6 > 0) {
                    j3dMessageArray2 = new J3dMessage[n6];
                }
                n2 = 0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (j3dMessageArray[i3].type == -1) continue;
                    j3dMessageArray2[n2++] = j3dMessageArray[i3];
                }
                if (j3dMessageArray2 != null) {
                    VirtualUniverse.mc.processMessage(j3dMessageArray2);
                }
            }
        }
    }

    int numChildren() {
        return this.children.size();
    }

    void removeLight(int n2, LightRetained[] lightRetainedArray, HashKey hashKey) {
        block3: {
            block2: {
                if (!this.inSharedGroup) break block2;
                int n3 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                ArrayList arrayList = (ArrayList)this.lights.get(n3);
                if (arrayList == null) break block3;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n4 = arrayList.indexOf(lightRetainedArray[i2]);
                    arrayList.remove(n4);
                }
                break block3;
            }
            ArrayList arrayList = (ArrayList)this.lights.get(0);
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = arrayList.indexOf(lightRetainedArray[i3]);
                arrayList.remove(n5);
            }
        }
    }

    void addAllNodesForScopedLight(int n2, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                hashKey.set(this.localToVworldKeys[i2]);
                this.processAllNodesForScopedLight(n2, lightRetainedArray, arrayList, hashKey);
            }
        } else {
            this.processAllNodesForScopedLight(n2, lightRetainedArray, arrayList, hashKey);
        }
    }

    void processAllNodesForScopedLight(int n2, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedLights) {
            this.addLight(lightRetainedArray, n2, hashKey);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                    ((GroupRetained)nodeRetained).processAllNodesForScopedLight(n2, lightRetainedArray, arrayList, hashKey);
                    continue;
                }
                if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                    int n3 = hashKey.count;
                    LinkRetained linkRetained = (LinkRetained)nodeRetained;
                    if (hashKey.count == 0) {
                        hashKey.append(this.locale.nodeId);
                    }
                    linkRetained.sharedGroup.processAllNodesForScopedLight(n2, lightRetainedArray, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                    hashKey.count = n3;
                    continue;
                }
                if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                    ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    continue;
                }
                if (!(nodeRetained instanceof MorphRetained) || !nodeRetained.source.isLive()) continue;
                ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
            }
        }
    }

    void removeAllNodesForScopedLight(int n2, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                hashKey.set(this.localToVworldKeys[i2]);
                this.processRemoveAllNodesForScopedLight(n2, lightRetainedArray, arrayList, hashKey);
            }
        } else {
            this.processRemoveAllNodesForScopedLight(n2, lightRetainedArray, arrayList, hashKey);
        }
    }

    void processRemoveAllNodesForScopedLight(int n2, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedLights) {
            this.removeLight(n2, lightRetainedArray, hashKey);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                    ((GroupRetained)nodeRetained).processRemoveAllNodesForScopedLight(n2, lightRetainedArray, arrayList, hashKey);
                    continue;
                }
                if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                    int n3 = hashKey.count;
                    LinkRetained linkRetained = (LinkRetained)nodeRetained;
                    if (hashKey.count == 0) {
                        hashKey.append(this.locale.nodeId);
                    }
                    linkRetained.sharedGroup.processRemoveAllNodesForScopedLight(n2, lightRetainedArray, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                    hashKey.count = n3;
                    continue;
                }
                if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                    ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    continue;
                }
                if (!(nodeRetained instanceof MorphRetained) || !nodeRetained.source.isLive()) continue;
                ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
            }
        }
    }

    void addAllNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                hashKey.set(this.localToVworldKeys[i2]);
                this.processAddNodesForScopedFog(fogRetained, arrayList, hashKey);
            }
        } else {
            this.processAddNodesForScopedFog(fogRetained, arrayList, hashKey);
        }
    }

    void processAddNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedFogs) {
            this.addFog(fogRetained, hashKey);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                    ((GroupRetained)nodeRetained).processAddNodesForScopedFog(fogRetained, arrayList, hashKey);
                    continue;
                }
                if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                    int n2 = hashKey.count;
                    LinkRetained linkRetained = (LinkRetained)nodeRetained;
                    if (hashKey.count == 0) {
                        hashKey.append(this.locale.nodeId);
                    }
                    linkRetained.sharedGroup.processAddNodesForScopedFog(fogRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                    hashKey.count = n2;
                    continue;
                }
                if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                    ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    continue;
                }
                if (!(nodeRetained instanceof MorphRetained) || !nodeRetained.source.isLive()) continue;
                ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
            }
        }
    }

    void removeAllNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                hashKey.set(this.localToVworldKeys[i2]);
                this.processRemoveAllNodesForScopedFog(fogRetained, arrayList, hashKey);
            }
        } else {
            this.processRemoveAllNodesForScopedFog(fogRetained, arrayList, hashKey);
        }
    }

    void processRemoveAllNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedFogs) {
            this.removeFog(fogRetained, hashKey);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                    ((GroupRetained)nodeRetained).processRemoveAllNodesForScopedFog(fogRetained, arrayList, hashKey);
                    continue;
                }
                if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                    int n2 = hashKey.count;
                    LinkRetained linkRetained = (LinkRetained)nodeRetained;
                    if (hashKey.count == 0) {
                        hashKey.append(this.locale.nodeId);
                    }
                    linkRetained.sharedGroup.processRemoveAllNodesForScopedFog(fogRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                    hashKey.count = n2;
                    continue;
                }
                if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                    ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    continue;
                }
                if (!(nodeRetained instanceof MorphRetained) || !nodeRetained.source.isLive()) continue;
                ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
            }
        }
    }

    void addAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                hashKey.set(this.localToVworldKeys[i2]);
                this.processAddNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
            }
        } else {
            this.processAddNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
        }
    }

    void processAddNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedMclips) {
            this.addModelClip(modelClipRetained, hashKey);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                    ((GroupRetained)nodeRetained).processAddNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
                    continue;
                }
                if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                    int n2 = hashKey.count;
                    LinkRetained linkRetained = (LinkRetained)nodeRetained;
                    if (hashKey.count == 0) {
                        hashKey.append(this.locale.nodeId);
                    }
                    linkRetained.sharedGroup.processAddNodesForScopedModelClip(modelClipRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                    hashKey.count = n2;
                    continue;
                }
                if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                    ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    continue;
                }
                if (!(nodeRetained instanceof MorphRetained) || !nodeRetained.source.isLive()) continue;
                ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
            }
        }
    }

    void removeAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                hashKey.set(this.localToVworldKeys[i2]);
                this.processRemoveAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
            }
        } else {
            this.processRemoveAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
        }
    }

    void processRemoveAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedMclips) {
            this.removeModelClip(modelClipRetained, hashKey);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                    ((GroupRetained)nodeRetained).processRemoveAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
                    continue;
                }
                if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                    int n2 = hashKey.count;
                    LinkRetained linkRetained = (LinkRetained)nodeRetained;
                    if (hashKey.count == 0) {
                        hashKey.append(this.locale.nodeId);
                    }
                    linkRetained.sharedGroup.processRemoveAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                    hashKey.count = n2;
                    continue;
                }
                if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                    ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    continue;
                }
                if (!(nodeRetained instanceof MorphRetained) || !nodeRetained.source.isLive()) continue;
                ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
            }
        }
    }

    void addAllNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                hashKey.set(this.localToVworldKeys[i2]);
                this.processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
            }
        } else {
            this.processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
        }
    }

    void processAddNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedAltApps) {
            this.addAltApp(alternateAppearanceRetained, hashKey);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                    ((GroupRetained)nodeRetained).processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
                    continue;
                }
                if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                    int n2 = hashKey.count;
                    LinkRetained linkRetained = (LinkRetained)nodeRetained;
                    if (hashKey.count == 0) {
                        hashKey.append(this.locale.nodeId);
                    }
                    linkRetained.sharedGroup.processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                    hashKey.count = n2;
                    continue;
                }
                if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                    ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    continue;
                }
                if (!(nodeRetained instanceof MorphRetained) || !nodeRetained.source.isLive()) continue;
                ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
            }
        }
    }

    void removeAllNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                hashKey.set(this.localToVworldKeys[i2]);
                this.processRemoveNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
            }
        } else {
            this.processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
        }
    }

    void processRemoveNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedAltApps) {
            this.removeAltApp(alternateAppearanceRetained, hashKey);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                    ((GroupRetained)nodeRetained).processRemoveNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
                    continue;
                }
                if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                    int n2 = hashKey.count;
                    LinkRetained linkRetained = (LinkRetained)nodeRetained;
                    if (hashKey.count == 0) {
                        hashKey.append(this.locale.nodeId);
                    }
                    linkRetained.sharedGroup.processRemoveNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                    hashKey.count = n2;
                    continue;
                }
                if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                    ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    continue;
                }
                if (!(nodeRetained instanceof MorphRetained) || !nodeRetained.source.isLive()) continue;
                ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
            }
        }
    }

    synchronized void setLightScope() {
        if (!this.allocatedLights) {
            ArrayList<Object> arrayList;
            this.allocatedLights = true;
            if (this.lights != null) {
                arrayList = new ArrayList<Object>(this.lights.size());
                int n2 = this.lights.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ArrayList arrayList2 = (ArrayList)this.lights.get(i2);
                    if (arrayList2 != null) {
                        arrayList.add(arrayList2.clone());
                        continue;
                    }
                    arrayList.add(null);
                }
            } else if (this.inSharedGroup) {
                arrayList = new ArrayList();
                for (int i3 = 0; i3 < this.localToVworldKeys.length; ++i3) {
                    arrayList.add(new ArrayList());
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add(new ArrayList());
            }
            this.lights = arrayList;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeLightScope() {
        --this.scopingRefCount;
    }

    synchronized void setFogScope() {
        if (!this.allocatedFogs) {
            ArrayList<Object> arrayList;
            this.allocatedFogs = true;
            if (this.fogs != null) {
                arrayList = new ArrayList<Object>(this.fogs.size());
                int n2 = this.fogs.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ArrayList arrayList2 = (ArrayList)this.fogs.get(i2);
                    if (arrayList2 != null) {
                        arrayList.add(arrayList2.clone());
                        continue;
                    }
                    arrayList.add(null);
                }
            } else if (this.inSharedGroup) {
                arrayList = new ArrayList();
                for (int i3 = 0; i3 < this.localToVworldKeys.length; ++i3) {
                    arrayList.add(new ArrayList());
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add(new ArrayList());
            }
            this.fogs = arrayList;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeFogScope() {
        --this.scopingRefCount;
    }

    synchronized void setMclipScope() {
        if (!this.allocatedMclips) {
            ArrayList<Object> arrayList;
            this.allocatedMclips = true;
            if (this.modelClips != null) {
                arrayList = new ArrayList<Object>(this.modelClips.size());
                int n2 = this.modelClips.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ArrayList arrayList2 = (ArrayList)this.modelClips.get(i2);
                    if (arrayList2 != null) {
                        arrayList.add(arrayList2.clone());
                        continue;
                    }
                    arrayList.add(null);
                }
            } else if (this.inSharedGroup) {
                arrayList = new ArrayList();
                for (int i3 = 0; i3 < this.localToVworldKeys.length; ++i3) {
                    arrayList.add(new ArrayList());
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add(new ArrayList());
            }
            this.modelClips = arrayList;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeMclipScope() {
        --this.scopingRefCount;
    }

    synchronized void setAltAppScope() {
        if (!this.allocatedAltApps) {
            ArrayList<Object> arrayList;
            this.allocatedAltApps = true;
            if (this.altAppearances != null) {
                arrayList = new ArrayList<Object>(this.altAppearances.size());
                int n2 = this.altAppearances.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ArrayList arrayList2 = (ArrayList)this.altAppearances.get(i2);
                    if (arrayList2 != null) {
                        arrayList.add(arrayList2.clone());
                        continue;
                    }
                    arrayList.add(null);
                }
            } else if (this.inSharedGroup) {
                arrayList = new ArrayList();
                for (int i3 = 0; i3 < this.localToVworldKeys.length; ++i3) {
                    arrayList.add(new ArrayList());
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add(new ArrayList());
            }
            this.altAppearances = arrayList;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeAltAppScope() {
        --this.scopingRefCount;
    }

    synchronized boolean usedInScoping() {
        return this.scopingRefCount > 0;
    }

    void addLight(LightRetained[] lightRetainedArray, int n2, HashKey hashKey) {
        block3: {
            block2: {
                if (!this.inSharedGroup) break block2;
                int n3 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                ArrayList arrayList = (ArrayList)this.lights.get(n3);
                if (arrayList == null) break block3;
                for (int i2 = 0; i2 < n2; ++i2) {
                    arrayList.add(lightRetainedArray[i2]);
                }
                break block3;
            }
            ArrayList arrayList = (ArrayList)this.lights.get(0);
            for (int i3 = 0; i3 < n2; ++i3) {
                arrayList.add(lightRetainedArray[i3]);
            }
        }
    }

    void addFog(FogRetained fogRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.fogs.get(n2);
            if (arrayList != null) {
                arrayList.add(fogRetained);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.fogs.get(0);
            arrayList.add(fogRetained);
        }
    }

    void addModelClip(ModelClipRetained modelClipRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.modelClips.get(n2);
            if (arrayList != null) {
                arrayList.add(modelClipRetained);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.modelClips.get(0);
            arrayList.add(modelClipRetained);
        }
    }

    void addAltApp(AlternateAppearanceRetained alternateAppearanceRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.altAppearances.get(n2);
            if (arrayList != null) {
                arrayList.add(alternateAppearanceRetained);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.altAppearances.get(0);
            arrayList.add(alternateAppearanceRetained);
        }
    }

    void removeFog(FogRetained fogRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.fogs.get(n2);
            if (arrayList != null) {
                int n3 = arrayList.indexOf(fogRetained);
                arrayList.remove(n3);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.fogs.get(0);
            int n4 = arrayList.indexOf(fogRetained);
            arrayList.remove(n4);
        }
    }

    void removeModelClip(ModelClipRetained modelClipRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.modelClips.get(n2);
            if (arrayList != null) {
                int n3 = arrayList.indexOf(modelClipRetained);
                arrayList.remove(n3);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.modelClips.get(0);
            int n4 = arrayList.indexOf(modelClipRetained);
            arrayList.remove(n4);
        }
    }

    void removeAltApp(AlternateAppearanceRetained alternateAppearanceRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.altAppearances.get(n2);
            if (arrayList != null) {
                int n3 = arrayList.indexOf(alternateAppearanceRetained);
                arrayList.remove(n3);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.altAppearances.get(0);
            int n4 = arrayList.indexOf(alternateAppearanceRetained);
            arrayList.remove(n4);
        }
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        NodeRetained nodeRetained;
        int n2 = this.children.size() - 1;
        super.updatePickable(hashKeyArray, blArray);
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            nodeRetained = (NodeRetained)this.children.get(n3);
            if (nodeRetained == null) continue;
            nodeRetained.updatePickable(hashKeyArray, (boolean[])blArray.clone());
        }
        nodeRetained = (NodeRetained)this.children.get(n3);
        if (nodeRetained != null) {
            nodeRetained.updatePickable(hashKeyArray, blArray);
        }
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        NodeRetained nodeRetained;
        int n2 = this.children.size() - 1;
        super.updateCollidable(hashKeyArray, blArray);
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            nodeRetained = (NodeRetained)this.children.get(n3);
            if (nodeRetained == null) continue;
            nodeRetained.updateCollidable(hashKeyArray, (boolean[])blArray.clone());
        }
        nodeRetained = (NodeRetained)this.children.get(n3);
        if (nodeRetained != null) {
            nodeRetained.updateCollidable(hashKeyArray, blArray);
        }
    }

    void setAlternateCollisionTarget(boolean bl) {
        if (this.collisionTarget == bl) {
            return;
        }
        this.collisionTarget = bl;
        if (this.source.isLive()) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 64;
            j3dMessage.universe = this.universe;
            CachedTargets[] cachedTargetsArray = null;
            if (bl) {
                this.createMirrorGroup();
                TargetsInterface targetsInterface = this.getClosestTargetsInterface(0);
                if (targetsInterface != null) {
                    Targets targets = new Targets();
                    int n2 = this.mirrorGroup.size();
                    cachedTargetsArray = new CachedTargets[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, i2, -1);
                        if (cachedTargets != null) {
                            targets.addNode((NnuId)this.mirrorGroup.get(i2), 6);
                            cachedTargetsArray[i2] = targets.snapShotAdd(cachedTargets);
                            continue;
                        }
                        cachedTargetsArray[i2] = null;
                    }
                    targetsInterface.updateTargetThreads(0, cachedTargetsArray);
                    targetsInterface.resetCachedTargets(0, cachedTargetsArray, -1);
                }
                j3dMessage.type = 0;
                j3dMessage.args[0] = this.mirrorGroup.toArray();
                j3dMessage.args[1] = targetsInterface;
                j3dMessage.args[2] = cachedTargetsArray;
            } else {
                TargetsInterface targetsInterface = this.getClosestTargetsInterface(0);
                if (targetsInterface != null) {
                    Targets targets = new Targets();
                    int n3 = this.mirrorGroup.size();
                    cachedTargetsArray = new CachedTargets[n3];
                    for (int i3 = 0; i3 < n3; ++i3) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, i3, -1);
                        if (cachedTargets != null) {
                            targets.addNode((NnuId)this.mirrorGroup.get(i3), 6);
                            cachedTargetsArray[i3] = targets.snapShotRemove(cachedTargets);
                            continue;
                        }
                        cachedTargetsArray[i3] = null;
                    }
                    targetsInterface.updateTargetThreads(0, cachedTargetsArray);
                    targetsInterface.resetCachedTargets(0, cachedTargetsArray, -1);
                }
                j3dMessage.type = 1;
                j3dMessage.args[0] = this.mirrorGroup.toArray();
                j3dMessage.args[1] = targetsInterface;
                j3dMessage.args[2] = cachedTargetsArray;
                this.mirrorGroup = null;
            }
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    boolean getAlternateCollisionTarget() {
        return this.collisionTarget;
    }

    void checkSetLive(NodeRetained nodeRetained, int n2, J3dMessage[] j3dMessageArray, int n3, NodeRetained nodeRetained2) {
        this.checkSetLive(nodeRetained, n2, this.localToVworldKeys, this.inSharedGroup, j3dMessageArray, n3, nodeRetained2);
    }

    void checkSetLive(NodeRetained nodeRetained, int n2, HashKey[] hashKeyArray, boolean bl, J3dMessage[] j3dMessageArray, int n3, NodeRetained nodeRetained2) {
        SceneGraphObject sceneGraphObject = this.source;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        if (sceneGraphObject.isLive()) {
            J3dMessage j3dMessage;
            int n4;
            int n5;
            boolean[] blArray;
            boolean[] blArray2;
            SetLiveState setLiveState = this.universe.setLiveState;
            setLiveState.reset(this.locale);
            setLiveState.refCount = this.refCount;
            setLiveState.inSharedGroup = bl;
            setLiveState.inBackgroundGroup = this.inBackgroundGroup;
            setLiveState.inViewSpecificGroup = this.inViewSpecificGroup;
            setLiveState.geometryBackground = this.geometryBackground;
            setLiveState.keys = hashKeyArray;
            setLiveState.viewLists = this.viewLists;
            setLiveState.parentBranchGroupPaths = this.branchGroupPaths;
            setLiveState.branchGroupPaths = (ArrayList)this.branchGroupPaths.clone();
            setLiveState.orderedPaths = this.orderedPaths;
            setLiveState.lights = this.lights;
            setLiveState.altAppearances = this.altAppearances;
            setLiveState.fogs = this.fogs;
            setLiveState.modelClips = this.modelClips;
            if (!this.inSharedGroup) {
                blArray2 = new boolean[1];
                blArray = new boolean[1];
            } else {
                blArray2 = new boolean[this.localToVworldKeys.length];
                blArray = new boolean[this.localToVworldKeys.length];
            }
            this.findPickableFlags(blArray2);
            super.updatePickable(null, blArray2);
            setLiveState.pickable = blArray2;
            this.findCollidableFlags(blArray);
            super.updateCollidable(null, blArray);
            setLiveState.collidable = blArray;
            TargetsInterface targetsInterface = this.initTransformStates(setLiveState, true);
            TargetsInterface targetsInterface2 = this.initSwitchStates(setLiveState, this, nodeRetained, nodeRetained2, true);
            if (setLiveState.inViewSpecificGroup && setLiveState.changedViewGroup == null) {
                setLiveState.changedViewGroup = new ArrayList();
                setLiveState.changedViewList = new ArrayList();
                setLiveState.keyList = new int[10];
                setLiveState.viewScopedNodeList = new ArrayList();
                setLiveState.scopedNodesViewList = new ArrayList();
            }
            this.childCheckSetLive(nodeRetained, n2, setLiveState, nodeRetained2);
            CachedTargets[] cachedTargetsArray = null;
            cachedTargetsArray = this.updateTransformStates(setLiveState, targetsInterface, true);
            this.updateSwitchStates(setLiveState, targetsInterface2, true);
            if (j3dMessageArray == null) {
                n5 = 2;
                if (setLiveState.ogList.size() > 0) {
                    ++n5;
                } else {
                    bl3 = false;
                }
                if (setLiveState.changedViewGroup != null) {
                    ++n5;
                } else {
                    bl4 = false;
                }
                j3dMessageArray = new J3dMessage[n5];
                n3 = 0;
                for (n4 = 0; n4 < n5; ++n4) {
                    j3dMessageArray[n4] = new J3dMessage();
                }
                bl2 = true;
            }
            if (bl3) {
                j3dMessage = j3dMessageArray[n3++];
                j3dMessage.threads = 4224;
                j3dMessage.type = 32;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = setLiveState.ogList.toArray();
                j3dMessage.args[1] = setLiveState.ogChildIdList.toArray();
                j3dMessage.args[2] = setLiveState.ogOrderedIdList.toArray();
                j3dMessage.args[3] = setLiveState.ogCIOList.toArray();
                j3dMessage.args[4] = setLiveState.ogCIOTableList.toArray();
            }
            if (bl4) {
                j3dMessage = j3dMessageArray[n3++];
                j3dMessage.threads = 4096;
                j3dMessage.type = 57;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = setLiveState.changedViewGroup;
                j3dMessage.args[1] = setLiveState.changedViewList;
                j3dMessage.args[2] = setLiveState.keyList;
            }
            j3dMessage = j3dMessageArray[n3++];
            j3dMessage.threads = setLiveState.notifyThreads;
            j3dMessage.type = 0;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.nodeList.toArray();
            if (cachedTargetsArray != null) {
                j3dMessage.args[1] = targetsInterface;
                j3dMessage.args[2] = cachedTargetsArray;
            } else {
                j3dMessage.args[1] = null;
                j3dMessage.args[2] = null;
            }
            if (setLiveState.viewScopedNodeList != null) {
                j3dMessage.args[3] = setLiveState.viewScopedNodeList;
                j3dMessage.args[4] = setLiveState.scopedNodesViewList;
            }
            n5 = setLiveState.behaviorNodes.size();
            for (n4 = 0; n4 < n5; ++n4) {
                BehaviorRetained behaviorRetained = (BehaviorRetained)setLiveState.behaviorNodes.get(n4);
                behaviorRetained.executeInitialize();
            }
            setLiveState.behaviorNodes.clear();
            j3dMessage = j3dMessageArray[n3++];
            j3dMessage.threads = 256;
            j3dMessage.type = 49;
            j3dMessage.universe = this.universe;
            if (bl2) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
            if (this.nodeType == 18) {
                SwitchRetained switchRetained = (SwitchRetained)this;
                switchRetained.setWhichChild(switchRetained.whichChild, true);
            }
            setLiveState.reset(null);
        }
    }

    void checkClearLive(NodeRetained nodeRetained, J3dMessage[] j3dMessageArray, int n2, int n3, NodeRetained nodeRetained2) {
        this.checkClearLive(nodeRetained, this.localToVworldKeys, this.inSharedGroup, j3dMessageArray, n2, n3, nodeRetained2);
    }

    void checkClearLive(NodeRetained nodeRetained, HashKey[] hashKeyArray, boolean bl, J3dMessage[] j3dMessageArray, int n2, int n3, NodeRetained nodeRetained2) {
        SceneGraphObject sceneGraphObject = this.source;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        if (sceneGraphObject.isLive()) {
            J3dMessage j3dMessage;
            Object object;
            Object object2;
            SetLiveState setLiveState = this.universe.setLiveState;
            setLiveState.reset(this.locale);
            setLiveState.refCount = this.refCount;
            setLiveState.inSharedGroup = bl;
            setLiveState.inBackgroundGroup = this.inBackgroundGroup;
            setLiveState.inViewSpecificGroup = this.inViewSpecificGroup;
            setLiveState.keys = hashKeyArray;
            setLiveState.fogs = this.fogs;
            setLiveState.lights = this.lights;
            setLiveState.altAppearances = this.altAppearances;
            setLiveState.modelClips = this.modelClips;
            if (setLiveState.inViewSpecificGroup && setLiveState.changedViewGroup == null) {
                setLiveState.changedViewGroup = new ArrayList();
                setLiveState.changedViewList = new ArrayList();
                setLiveState.keyList = new int[10];
                setLiveState.viewScopedNodeList = new ArrayList();
                setLiveState.scopedNodesViewList = new ArrayList();
            }
            if (this instanceof OrderedGroupRetained && nodeRetained2 == null) {
                setLiveState.ogList.add(this);
                setLiveState.ogChildIdList.add(new Integer(n3));
                setLiveState.ogCIOList.add(this);
                object2 = null;
                object = (OrderedGroupRetained)this;
                if (((OrderedGroupRetained)object).userChildIndexOrder != null) {
                    object2 = new int[((OrderedGroupRetained)object).userChildIndexOrder.length];
                    System.arraycopy(((OrderedGroupRetained)object).userChildIndexOrder, 0, object2, 0, ((OrderedGroupRetained)object).userChildIndexOrder.length);
                }
                setLiveState.ogCIOTableList.add(object2);
            }
            setLiveState.viewLists = this.viewLists;
            object2 = this.initTransformStates(setLiveState, false);
            object = this.initSwitchStates(setLiveState, this, nodeRetained, nodeRetained2, false);
            nodeRetained.clearLive(setLiveState);
            CachedTargets[] cachedTargetsArray = null;
            cachedTargetsArray = this.updateTransformStates(setLiveState, (TargetsInterface)object2, false);
            this.updateSwitchStates(setLiveState, (TargetsInterface)object, false);
            if (j3dMessageArray == null) {
                int n4 = 1;
                if (setLiveState.ogList.size() > 0) {
                    ++n4;
                } else {
                    bl3 = false;
                }
                if (setLiveState.changedViewGroup != null) {
                    ++n4;
                } else {
                    bl4 = false;
                }
                j3dMessageArray = new J3dMessage[n4];
                n2 = 0;
                for (int i2 = 0; i2 < n4; ++i2) {
                    j3dMessageArray[i2] = new J3dMessage();
                }
                bl2 = true;
            }
            if (bl3) {
                j3dMessage = j3dMessageArray[n2++];
                j3dMessage.threads = 4224;
                j3dMessage.type = 33;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = setLiveState.ogList.toArray();
                j3dMessage.args[1] = setLiveState.ogChildIdList.toArray();
                j3dMessage.args[3] = setLiveState.ogCIOList.toArray();
                j3dMessage.args[4] = setLiveState.ogCIOTableList.toArray();
            }
            j3dMessage = j3dMessageArray[n2++];
            j3dMessage.threads = setLiveState.notifyThreads;
            j3dMessage.type = 1;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.nodeList.toArray();
            if (cachedTargetsArray != null) {
                j3dMessage.args[1] = object2;
                j3dMessage.args[2] = cachedTargetsArray;
            } else {
                j3dMessage.args[1] = null;
                j3dMessage.args[2] = null;
            }
            if (setLiveState.viewScopedNodeList != null) {
                j3dMessage.args[3] = setLiveState.viewScopedNodeList;
                j3dMessage.args[4] = setLiveState.scopedNodesViewList;
            }
            if (bl4) {
                j3dMessage = j3dMessageArray[n2++];
                j3dMessage.threads = 4096;
                j3dMessage.type = 58;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = setLiveState.changedViewGroup;
                j3dMessage.args[1] = setLiveState.keyList;
            }
            if (bl2) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
            setLiveState.reset(null);
        }
    }

    TargetsInterface initTransformStates(SetLiveState setLiveState, boolean bl) {
        Object object;
        int n2 = this.inSharedGroup ? setLiveState.keys.length : 1;
        TargetsInterface targetsInterface = this.getClosestTargetsInterface(0);
        if (bl) {
            setLiveState.currentTransforms = this.localToVworld;
            setLiveState.currentTransformsIndex = this.localToVworldIndex;
            setLiveState.localToVworldKeys = this.localToVworldKeys;
            setLiveState.localToVworld = setLiveState.currentTransforms;
            setLiveState.localToVworldIndex = setLiveState.currentTransformsIndex;
            setLiveState.parentTransformLink = this.parentTransformLink;
            if (this.parentTransformLink != null) {
                if (this.parentTransformLink instanceof TransformGroupRetained) {
                    object = (TransformGroupRetained)this.parentTransformLink;
                    setLiveState.childTransformLinks = object.childTransformLinks;
                } else {
                    object = (SharedGroupRetained)this.parentTransformLink;
                    setLiveState.childTransformLinks = object.childTransformLinks;
                }
            }
        }
        object = new int[n2];
        this.findTransformLevels((int[])object);
        setLiveState.transformLevels = object;
        if (targetsInterface != null) {
            Targets[] targetsArray = new Targets[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                targetsArray[i2] = setLiveState.transformLevels[i2] >= 0 ? new Targets() : null;
            }
            setLiveState.transformTargets = targetsArray;
        }
        return targetsInterface;
    }

    CachedTargets[] updateTransformStates(SetLiveState setLiveState, TargetsInterface targetsInterface, boolean bl) {
        CachedTargets[] cachedTargetsArray = null;
        if (targetsInterface != null) {
            if (bl) {
                boolean bl2 = false;
                cachedTargetsArray = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (setLiveState.transformTargets[0] != null) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, 0, -1);
                        if (cachedTargets != null) {
                            cachedTargetsArray[0] = setLiveState.transformTargets[0].snapShotAdd(cachedTargets);
                        }
                    } else {
                        cachedTargetsArray[0] = null;
                    }
                } else {
                    for (int i2 = 0; i2 < setLiveState.keys.length; ++i2) {
                        if (setLiveState.transformTargets[i2] != null) {
                            CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, i2, -1);
                            if (cachedTargets == null) continue;
                            cachedTargetsArray[i2] = setLiveState.transformTargets[i2].snapShotAdd(cachedTargets);
                            continue;
                        }
                        cachedTargetsArray[i2] = null;
                    }
                }
            } else {
                cachedTargetsArray = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (setLiveState.transformTargets[0] != null) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, 0, -1);
                        if (cachedTargets != null) {
                            cachedTargetsArray[0] = setLiveState.transformTargets[0].snapShotRemove(cachedTargets);
                        }
                    } else {
                        cachedTargetsArray[0] = null;
                    }
                } else {
                    for (int i3 = 0; i3 < setLiveState.keys.length; ++i3) {
                        if (setLiveState.transformTargets[i3] != null) {
                            CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, i3, -1);
                            if (cachedTargets == null) continue;
                            cachedTargetsArray[i3] = setLiveState.transformTargets[i3].snapShotRemove(cachedTargets);
                            continue;
                        }
                        cachedTargetsArray[i3] = null;
                    }
                }
            }
            targetsInterface.updateTargetThreads(0, cachedTargetsArray);
            targetsInterface.resetCachedTargets(0, cachedTargetsArray, -1);
        }
        return cachedTargetsArray;
    }

    TargetsInterface initSwitchStates(SetLiveState setLiveState, NodeRetained nodeRetained, NodeRetained nodeRetained2, NodeRetained nodeRetained3, boolean bl) {
        int n2;
        this.findSwitchInfo(setLiveState, nodeRetained, nodeRetained2, nodeRetained3);
        TargetsInterface targetsInterface = this.getClosestTargetsInterface(1);
        if (targetsInterface != null) {
            Targets[] targetsArray = null;
            int n3 = this.inSharedGroup ? setLiveState.keys.length : 1;
            targetsArray = new Targets[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                targetsArray[n2] = setLiveState.switchLevels[n2] >= 0 ? new Targets() : null;
            }
            setLiveState.switchTargets = targetsArray;
        }
        if (bl) {
            if (this.nodeType == 18) {
                n2 = this.parentSwitchLinkChildIndex;
                setLiveState.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(n2);
                setLiveState.parentSwitchLink = this;
            } else if (this.nodeType == 22) {
                n2 = this.parentSwitchLinkChildIndex;
                setLiveState.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(n2);
                setLiveState.parentSwitchLink = this;
            } else {
                setLiveState.parentSwitchLink = this.parentSwitchLink;
                if (this.parentSwitchLink != null) {
                    n2 = this.parentSwitchLinkChildIndex;
                    setLiveState.childSwitchLinks = (ArrayList)this.parentSwitchLink.childrenSwitchLinks.get(n2);
                }
            }
            if (targetsInterface != null) {
                setLiveState.switchStates = targetsInterface.getTargetsData(1, this.parentSwitchLinkChildIndex);
            } else {
                setLiveState.switchStates = new ArrayList(1);
                setLiveState.switchStates.add(new SwitchState(false));
            }
        }
        return targetsInterface;
    }

    void updateSwitchStates(SetLiveState setLiveState, TargetsInterface targetsInterface, boolean bl) {
        if (targetsInterface != null) {
            if (bl) {
                CachedTargets[] cachedTargetsArray = null;
                cachedTargetsArray = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    CachedTargets cachedTargets;
                    cachedTargetsArray[0] = setLiveState.switchTargets[0] != null ? ((cachedTargets = targetsInterface.getCachedTargets(1, 0, this.parentSwitchLinkChildIndex)) != null ? setLiveState.switchTargets[0].snapShotAdd(cachedTargets) : setLiveState.switchTargets[0].snapShotInit()) : null;
                } else {
                    for (int i2 = 0; i2 < setLiveState.keys.length; ++i2) {
                        if (setLiveState.switchTargets[i2] != null) {
                            CachedTargets cachedTargets = targetsInterface.getCachedTargets(1, i2, this.parentSwitchLinkChildIndex);
                            if (cachedTargets != null) {
                                cachedTargetsArray[i2] = setLiveState.switchTargets[i2].snapShotAdd(cachedTargets);
                                continue;
                            }
                            cachedTargetsArray[i2] = setLiveState.switchTargets[i2].snapShotInit();
                            continue;
                        }
                        cachedTargetsArray[i2] = null;
                    }
                }
                targetsInterface.resetCachedTargets(1, cachedTargetsArray, this.parentSwitchLinkChildIndex);
                if (targetsInterface instanceof SwitchRetained) {
                    ((SwitchRetained)targetsInterface).traverseSwitchParent();
                } else if (targetsInterface instanceof SharedGroupRetained) {
                    ((SharedGroupRetained)targetsInterface).traverseSwitchParent();
                }
            } else {
                CachedTargets[] cachedTargetsArray = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (setLiveState.switchTargets[0] != null) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(1, 0, this.parentSwitchLinkChildIndex);
                        if (cachedTargets != null) {
                            cachedTargetsArray[0] = setLiveState.switchTargets[0].snapShotRemove(cachedTargets);
                        }
                    } else {
                        cachedTargetsArray[0] = null;
                    }
                } else {
                    for (int i3 = 0; i3 < setLiveState.keys.length; ++i3) {
                        if (setLiveState.switchTargets[i3] != null) {
                            CachedTargets cachedTargets = targetsInterface.getCachedTargets(1, i3, this.parentSwitchLinkChildIndex);
                            if (cachedTargets == null) continue;
                            cachedTargetsArray[i3] = setLiveState.switchTargets[i3].snapShotRemove(cachedTargets);
                            continue;
                        }
                        cachedTargetsArray[i3] = null;
                    }
                }
                targetsInterface.resetCachedTargets(1, cachedTargetsArray, this.parentSwitchLinkChildIndex);
            }
        }
    }

    void appendChildrenData() {
    }

    void insertChildrenData(int n2) {
    }

    void removeChildrenData(int n2) {
    }

    TargetsInterface getClosestTargetsInterface(int n2) {
        return n2 == 0 ? (TargetsInterface)((Object)this.parentTransformLink) : (TargetsInterface)((Object)this.parentSwitchLink);
    }

    synchronized void updateLocalToVworld() {
        for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
            if (nodeRetained == null) continue;
            nodeRetained.updateLocalToVworld();
        }
    }

    void setNodeData(SetLiveState setLiveState) {
        super.setNodeData(setLiveState);
        this.orderedPaths = setLiveState.orderedPaths;
    }

    void removeNodeData(SetLiveState setLiveState) {
        this.orderedPaths = !this.inSharedGroup || setLiveState.keys.length == this.localToVworld.length ? null : setLiveState.orderedPaths;
        super.removeNodeData(setLiveState);
    }

    void setLive(SetLiveState setLiveState) {
        this.doSetLive(setLiveState);
        super.markAsLive();
    }

    void childDoSetLive(NodeRetained nodeRetained, int n2, SetLiveState setLiveState) {
        if (nodeRetained != null) {
            nodeRetained.setLive(setLiveState);
        }
    }

    void childCheckSetLive(NodeRetained nodeRetained, int n2, SetLiveState setLiveState, NodeRetained nodeRetained2) {
        nodeRetained.setLive(setLiveState);
    }

    void doSetLive(SetLiveState setLiveState) {
        BoundingSphere boundingSphere = new BoundingSphere();
        super.doSetLive(setLiveState);
        this.locale = setLiveState.locale;
        this.inViewSpecificGroup = setLiveState.inViewSpecificGroup;
        int n2 = this.children.size();
        ArrayList arrayList = setLiveState.lights;
        ArrayList arrayList2 = setLiveState.fogs;
        ArrayList arrayList3 = setLiveState.altAppearances;
        ArrayList arrayList4 = setLiveState.modelClips;
        boolean[] blArray = (boolean[])setLiveState.pickable.clone();
        boolean[] blArray2 = (boolean[])setLiveState.collidable.clone();
        boolean[] blArray3 = new boolean[blArray.length];
        boolean[] blArray4 = new boolean[blArray2.length];
        ArrayList arrayList5 = setLiveState.branchGroupPaths;
        this.setScopingInfo(setLiveState);
        if (!(this instanceof ViewSpecificGroupRetained)) {
            this.viewLists = setLiveState.viewLists;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
            System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
            System.arraycopy(blArray2, 0, blArray4, 0, blArray2.length);
            setLiveState.pickable = blArray3;
            setLiveState.collidable = blArray4;
            setLiveState.parentBranchGroupPaths = this.branchGroupPaths;
            setLiveState.branchGroupPaths = (ArrayList)arrayList5.clone();
            setLiveState.inViewSpecificGroup = this.inViewSpecificGroup;
            this.childDoSetLive(nodeRetained, i2, setLiveState);
        }
        if (this.collisionTarget) {
            this.processCollisionTarget(setLiveState);
        }
        setLiveState.lights = arrayList;
        setLiveState.fogs = arrayList2;
        setLiveState.altAppearances = arrayList3;
        setLiveState.modelClips = arrayList4;
    }

    void setScopingInfo(SetLiveState setLiveState) {
        int n2;
        int n3;
        ArrayList arrayList;
        ArrayList arrayList2;
        int n4;
        int n5;
        if (this.allocatedLights) {
            if (setLiveState.lights != null) {
                if (this.inSharedGroup) {
                    for (n5 = 0; n5 < setLiveState.keys.length; ++n5) {
                        n4 = setLiveState.keys[n5].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        arrayList2 = (ArrayList)this.lights.get(n4);
                        arrayList = (ArrayList)setLiveState.lights.get(n5);
                        if (arrayList == null) continue;
                        n3 = arrayList.size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList2.add(arrayList.get(n2));
                        }
                    }
                } else {
                    arrayList2 = (ArrayList)this.lights.get(0);
                    arrayList = (ArrayList)setLiveState.lights.get(0);
                    n3 = arrayList.size();
                    for (n5 = 0; n5 < n3; ++n5) {
                        arrayList2.add(arrayList.get(n5));
                    }
                }
            }
            setLiveState.lights = this.lights;
        } else {
            this.lights = setLiveState.lights;
        }
        if (this.allocatedFogs) {
            if (setLiveState.fogs != null) {
                if (this.inSharedGroup) {
                    for (n5 = 0; n5 < setLiveState.keys.length; ++n5) {
                        n4 = setLiveState.keys[n5].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        arrayList2 = (ArrayList)this.fogs.get(n4);
                        arrayList = (ArrayList)setLiveState.fogs.get(n5);
                        if (arrayList == null) continue;
                        n3 = arrayList.size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList2.add(arrayList.get(n2));
                        }
                    }
                } else {
                    arrayList2 = (ArrayList)this.fogs.get(0);
                    arrayList = (ArrayList)setLiveState.fogs.get(0);
                    n3 = arrayList.size();
                    for (n5 = 0; n5 < n3; ++n5) {
                        arrayList2.add(arrayList.get(n5));
                    }
                }
            }
            setLiveState.fogs = this.fogs;
        } else {
            this.fogs = setLiveState.fogs;
        }
        if (this.allocatedMclips) {
            if (setLiveState.modelClips != null) {
                if (this.inSharedGroup) {
                    for (n5 = 0; n5 < setLiveState.keys.length; ++n5) {
                        n4 = setLiveState.keys[n5].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        arrayList2 = (ArrayList)this.modelClips.get(n4);
                        arrayList = (ArrayList)setLiveState.modelClips.get(n5);
                        if (arrayList == null) continue;
                        n3 = arrayList.size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList2.add(arrayList.get(n2));
                        }
                    }
                } else {
                    arrayList2 = (ArrayList)this.modelClips.get(0);
                    arrayList = (ArrayList)setLiveState.modelClips.get(0);
                    n3 = arrayList.size();
                    for (n5 = 0; n5 < n3; ++n5) {
                        arrayList2.add(arrayList.get(n5));
                    }
                }
            }
            setLiveState.modelClips = this.modelClips;
        } else {
            this.modelClips = setLiveState.modelClips;
        }
        if (this.allocatedAltApps) {
            if (setLiveState.altAppearances != null) {
                if (this.inSharedGroup) {
                    for (n5 = 0; n5 < setLiveState.keys.length; ++n5) {
                        n4 = setLiveState.keys[n5].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        arrayList2 = (ArrayList)this.altAppearances.get(n4);
                        arrayList = (ArrayList)setLiveState.altAppearances.get(n5);
                        if (arrayList == null) continue;
                        n3 = arrayList.size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList2.add(arrayList.get(n2));
                        }
                    }
                } else {
                    arrayList2 = (ArrayList)this.altAppearances.get(0);
                    arrayList = (ArrayList)setLiveState.altAppearances.get(0);
                    n3 = arrayList.size();
                    for (n5 = 0; n5 < n3; ++n5) {
                        arrayList2.add(arrayList.get(n5));
                    }
                }
            }
            setLiveState.altAppearances = this.altAppearances;
        } else {
            this.altAppearances = setLiveState.altAppearances;
        }
    }

    void processCollisionTarget(SetLiveState setLiveState) {
        Bounds bounds;
        if (this.mirrorGroup == null) {
            this.mirrorGroup = new ArrayList();
        }
        Bounds bounds2 = bounds = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < setLiveState.keys.length; ++i2) {
                GroupRetained groupRetained = new GroupRetained();
                groupRetained.key = setLiveState.keys[i2];
                groupRetained.localToVworld = new Transform3D[1][];
                groupRetained.localToVworldIndex = new int[1][];
                int n2 = setLiveState.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 < 0) {
                    System.err.println("GroupRetained : Can't find hashKey");
                }
                groupRetained.localToVworld[0] = this.localToVworld[n2];
                groupRetained.localToVworldIndex[0] = this.localToVworldIndex[n2];
                groupRetained.collisionVwcBounds = new BoundingBox();
                groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld(0));
                groupRetained.sourceNode = this;
                groupRetained.locale = this.locale;
                this.mirrorGroup.add(groupRetained);
                if (setLiveState.transformTargets != null && setLiveState.transformTargets[i2] != null) {
                    setLiveState.transformTargets[i2].addNode(groupRetained, 6);
                }
                setLiveState.nodeList.add(groupRetained);
            }
        } else {
            GroupRetained groupRetained = new GroupRetained();
            groupRetained.localToVworld = new Transform3D[1][];
            groupRetained.localToVworldIndex = new int[1][];
            groupRetained.localToVworld[0] = this.localToVworld[0];
            groupRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            groupRetained.collisionVwcBounds = new BoundingBox();
            groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld(0));
            groupRetained.sourceNode = this;
            groupRetained.locale = this.locale;
            this.mirrorGroup.add(groupRetained);
            if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                setLiveState.transformTargets[0].addNode(groupRetained, 6);
            }
            setLiveState.nodeList.add(groupRetained);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeCombineBounds(Bounds bounds) {
        if (!VirtualUniverse.mc.cacheAutoComputedBounds) {
            if (this.boundsAutoCompute) {
                for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                    NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                    if (nodeRetained == null) continue;
                    nodeRetained.computeCombineBounds(bounds);
                }
            } else {
                Bounds bounds2 = this.localBounds;
                synchronized (bounds2) {
                    bounds.combine(this.localBounds);
                }
            }
        } else {
            if (this.cachedBounds != null && this.boundsAutoCompute) {
                bounds.combine(this.cachedBounds);
                return;
            }
            if (this.boundsAutoCompute) {
                this.cachedBounds = new BoundingSphere();
                ((BoundingSphere)this.cachedBounds).setRadius(-1.0);
                for (int i3 = this.children.size() - 1; i3 >= 0; --i3) {
                    NodeRetained nodeRetained = (NodeRetained)this.children.get(i3);
                    if (nodeRetained == null) continue;
                    nodeRetained.computeCombineBounds(this.cachedBounds);
                }
                bounds.combine(this.cachedBounds);
            } else {
                Bounds bounds3 = this.localBounds;
                synchronized (bounds3) {
                    bounds.combine(this.localBounds);
                }
            }
        }
    }

    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            if (this.cachedBounds != null) {
                return (Bounds)this.cachedBounds.clone();
            }
            BoundingSphere boundingSphere = new BoundingSphere();
            boundingSphere.setRadius(-1.0);
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                nodeRetained.computeCombineBounds(boundingSphere);
            }
            return boundingSphere;
        }
        return super.getBounds();
    }

    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    boolean isStaticChildren() {
        if (this.source.getCapability(12) || this.source.getCapability(13)) {
            return false;
        }
        for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(i2);
            if (sceneGraphObjectRetained == null || !sceneGraphObjectRetained.source.getCapability(46)) continue;
            return false;
        }
        return true;
    }

    boolean isStatic() {
        return super.isStatic() && this.isStaticChildren();
    }

    void setCompiled() {
        super.setCompiled();
        for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(i2);
            if (sceneGraphObjectRetained == null) continue;
            sceneGraphObjectRetained.setCompiled();
        }
    }

    void traverse(boolean bl, int n2) {
        if (!bl) {
            super.traverse(true, n2);
            if (this.source.getCapability(12)) {
                System.err.print(" (r)");
            } else if (this.isStatic()) {
                System.err.print(" (s)");
            } else if (this.source.getCapability(13)) {
                System.err.print(" (w)");
            }
        }
        ++n2;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(i2);
            if (sceneGraphObjectRetained == null) continue;
            sceneGraphObjectRetained.traverse(false, n2);
        }
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        this.mergeFlag = 1;
        if (!this.isStatic()) {
            compileState.keepTG = true;
            this.mergeFlag = 0;
        }
        if (this.isRoot || this.usedInScoping() || this.parent instanceof SwitchRetained) {
            this.mergeFlag = 0;
        }
        this.compiledChildrenList = new ArrayList(5);
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(i2);
            if (sceneGraphObjectRetained == null) continue;
            sceneGraphObjectRetained.compile(compileState);
        }
    }

    void merge(CompileState compileState) {
        GroupRetained groupRetained = null;
        if (this.mergeFlag != 2) {
            if (this.mergeFlag == 0) {
                super.merge(compileState);
                groupRetained = compileState.parentGroup;
                compileState.parentGroup = this;
            }
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(i2);
                if (sceneGraphObjectRetained == null) continue;
                sceneGraphObjectRetained.merge(compileState);
            }
            if (compileState.parentGroup == this) {
                this.children = this.compiledChildrenList;
                compileState.doShapeMerge();
                this.compiledChildrenList = null;
                compileState.parentGroup = groupRetained;
            } else {
                this.children.clear();
            }
            this.mergeFlag = 2;
        } else if (compileState.parentGroup != null) {
            compileState.parentGroup.compiledChildrenList.add(this);
            this.parent = compileState.parentGroup;
        }
    }

    void clearLive(SetLiveState setLiveState) {
        int n2;
        int n3;
        int n4;
        ArrayList arrayList;
        int n5;
        Cloneable cloneable;
        int n6;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        this.isInClearLive = true;
        HashKey[] hashKeyArray = this.localToVworldKeys;
        super.clearLive(setLiveState);
        int n7 = this.children.size();
        if (!(this instanceof ViewSpecificGroupRetained)) {
            this.viewLists = setLiveState.viewLists;
        }
        ArrayList arrayList2 = setLiveState.lights;
        if (this.allocatedLights) {
            setLiveState.lights = this.lights;
        }
        ArrayList arrayList3 = setLiveState.fogs;
        if (this.allocatedFogs) {
            setLiveState.fogs = this.fogs;
        }
        ArrayList arrayList4 = setLiveState.modelClips;
        if (this.allocatedMclips) {
            setLiveState.modelClips = this.modelClips;
        }
        ArrayList arrayList5 = setLiveState.altAppearances;
        if (this.allocatedAltApps) {
            setLiveState.altAppearances = this.altAppearances;
        }
        for (n6 = n7 - 1; n6 >= 0; --n6) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(n6);
            if (this instanceof OrderedGroupRetained) {
                cloneable = (OrderedGroupRetained)this;
                if (this.refCount + 1 == setLiveState.refCount) {
                    setLiveState.ogList.add(this);
                    setLiveState.ogChildIdList.add(new Integer(n6));
                }
                setLiveState.orderedPaths = (ArrayList)((OrderedGroupRetained)cloneable).childrenOrderedPaths.get(n6);
            }
            if (nodeRetained == null) continue;
            nodeRetained.clearLive(setLiveState);
        }
        if (arrayList2 != null && this.allocatedLights) {
            if (this.inSharedGroup) {
                for (n6 = 0; n6 < setLiveState.keys.length; ++n6) {
                    n5 = setLiveState.keys[n6].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    cloneable = (ArrayList)arrayList2.get(n5);
                    arrayList = (ArrayList)this.lights.get(n5);
                    if (cloneable == null) continue;
                    n4 = ((ArrayList)cloneable).size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        arrayList.remove(((ArrayList)cloneable).get(n3));
                    }
                }
            } else {
                cloneable = (ArrayList)arrayList2.get(0);
                arrayList = (ArrayList)this.lights.get(0);
                n4 = ((ArrayList)cloneable).size();
                for (n2 = 0; n2 < n4; ++n2) {
                    arrayList.remove(((ArrayList)cloneable).get(n2));
                }
            }
        }
        if (arrayList3 != null && this.allocatedFogs) {
            if (this.inSharedGroup) {
                for (n6 = 0; n6 < setLiveState.keys.length; ++n6) {
                    n5 = setLiveState.keys[n6].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    cloneable = (ArrayList)arrayList3.get(n5);
                    arrayList = (ArrayList)this.fogs.get(n5);
                    if (cloneable == null) continue;
                    n4 = ((ArrayList)cloneable).size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        arrayList.remove(((ArrayList)cloneable).get(n3));
                    }
                }
            } else {
                cloneable = (ArrayList)arrayList3.get(0);
                n4 = ((ArrayList)cloneable).size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.fogs.remove(((ArrayList)cloneable).get(i2));
                }
            }
        }
        if (arrayList4 != null && this.allocatedMclips) {
            if (this.inSharedGroup) {
                for (n6 = 0; n6 < setLiveState.keys.length; ++n6) {
                    n5 = setLiveState.keys[n6].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    cloneable = (ArrayList)arrayList4.get(n5);
                    ArrayList arrayList6 = (ArrayList)this.modelClips.get(n5);
                    if (cloneable == null) continue;
                    n4 = ((ArrayList)cloneable).size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        arrayList6.remove(((ArrayList)cloneable).get(n3));
                    }
                }
            } else {
                cloneable = (ArrayList)arrayList4.get(0);
                n4 = ((ArrayList)cloneable).size();
                for (int i3 = 0; i3 < n4; ++i3) {
                    this.modelClips.remove(((ArrayList)cloneable).get(i3));
                }
            }
        }
        if (arrayList5 != null && this.allocatedAltApps) {
            if (this.inSharedGroup) {
                for (n6 = 0; n6 < setLiveState.keys.length; ++n6) {
                    n5 = setLiveState.keys[n6].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    cloneable = (ArrayList)arrayList5.get(n5);
                    ArrayList arrayList7 = (ArrayList)this.altAppearances.get(n5);
                    if (cloneable == null) continue;
                    n4 = ((ArrayList)cloneable).size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        arrayList7.remove(((ArrayList)cloneable).get(n3));
                    }
                }
            } else {
                cloneable = (ArrayList)arrayList5.get(0);
                n4 = ((ArrayList)cloneable).size();
                for (int i4 = 0; i4 < n4; ++i4) {
                    this.altAppearances.remove(((ArrayList)cloneable).get(i4));
                }
            }
        }
        if (this.collisionTarget) {
            if (this.inSharedGroup) {
                block13: for (n6 = setLiveState.keys.length - 1; n6 >= 0; --n6) {
                    HashKey hashKey = setLiveState.keys[n6];
                    for (n2 = this.mirrorGroup.size() - 1; n2 >= 0; --n2) {
                        cloneable = (GroupRetained)this.mirrorGroup.get(n2);
                        if (!((GroupRetained)cloneable).key.equals((Object)hashKey)) continue;
                        setLiveState.nodeList.add(this.mirrorGroup.remove(n2));
                        if (setLiveState.transformTargets == null || setLiveState.transformTargets[n2] == null) continue block13;
                        setLiveState.transformTargets[n2].addNode((NnuId)((Object)cloneable), 6);
                        continue block13;
                    }
                }
            } else {
                cloneable = (GroupRetained)this.mirrorGroup.get(0);
                if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                    setLiveState.transformTargets[0].addNode((NnuId)((Object)cloneable), 6);
                }
                setLiveState.nodeList.add(this.mirrorGroup.remove(0));
            }
        }
        setLiveState.lights = arrayList2;
        setLiveState.modelClips = arrayList4;
        setLiveState.fogs = arrayList3;
        setLiveState.altAppearances = arrayList5;
        this.isInClearLive = false;
    }

    public BoundingBox computeBoundingHull() {
        return this.collisionVwcBounds;
    }

    public boolean isEnable() {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    public boolean isEnable(int n2) {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    public Locale getLocale2() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isNodeSwitchOn(NodeRetained nodeRetained, HashKey hashKey) {
        NodeRetained nodeRetained2 = null;
        if (hashKey != null) {
            hashKey = new HashKey(hashKey);
        }
        Object object = nodeRetained.universe.sceneGraphLock;
        synchronized (object) {
            do {
                if (nodeRetained instanceof SwitchRetained && nodeRetained2 != null && !GroupRetained.validSwitchChild((SwitchRetained)nodeRetained, nodeRetained2)) {
                    return false;
                }
                nodeRetained2 = nodeRetained;
                if (nodeRetained instanceof SharedGroupRetained) {
                    String string = hashKey.getLastNodeId();
                    Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                    for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
                        NodeRetained nodeRetained3 = (NodeRetained)vector.get(i2);
                        if (!nodeRetained3.nodeId.equals(string)) continue;
                        nodeRetained = nodeRetained3;
                        break;
                    }
                    if (nodeRetained != nodeRetained2) continue;
                    return false;
                }
                nodeRetained = nodeRetained.parent;
            } while (nodeRetained != null);
        }
        return true;
    }

    static boolean validSwitchChild(SwitchRetained switchRetained, NodeRetained nodeRetained) {
        int n2 = switchRetained.whichChild;
        if (n2 == -1) {
            return false;
        }
        if (n2 == -2) {
            return true;
        }
        ArrayList arrayList = switchRetained.children;
        if (n2 >= 0) {
            return arrayList.get(n2) == nodeRetained;
        }
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            if (!switchRetained.childMask.get(i2) || arrayList.get(i2) != nodeRetained) continue;
            return true;
        }
        return false;
    }

    void createMirrorGroup() {
        Bounds bounds;
        this.mirrorGroup = new ArrayList();
        Bounds bounds2 = bounds = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                GroupRetained groupRetained = new GroupRetained();
                groupRetained.key = this.localToVworldKeys[i2];
                groupRetained.localToVworld = new Transform3D[1][];
                groupRetained.localToVworldIndex = new int[1][];
                groupRetained.localToVworld[0] = this.localToVworld[i2];
                groupRetained.localToVworldIndex[0] = this.localToVworldIndex[i2];
                groupRetained.collisionVwcBounds = new BoundingBox();
                groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld());
                groupRetained.sourceNode = this;
                groupRetained.locale = this.locale;
                this.mirrorGroup.add(groupRetained);
            }
        } else {
            GroupRetained groupRetained = new GroupRetained();
            groupRetained.localToVworld = new Transform3D[1][];
            groupRetained.localToVworldIndex = new int[1][];
            groupRetained.localToVworld[0] = this.localToVworld[0];
            groupRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            groupRetained.collisionVwcBounds = new BoundingBox();
            groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld());
            groupRetained.sourceNode = this;
            groupRetained.locale = this.locale;
            this.mirrorGroup.add(groupRetained);
        }
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            super.setBoundsAutoCompute(bl);
            if (!bl) {
                this.localBounds = this.getEffectiveBounds();
            }
            if (this.source.isLive() && this.collisionBound == null && bl && this.mirrorGroup != null) {
                J3dMessage j3dMessage = new J3dMessage();
                j3dMessage.type = 34;
                j3dMessage.threads = 8256;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = this;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute && this.collisionBound == null && this.mirrorGroup != null) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8256;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    int[] processViewSpecificInfo(int n2, HashKey hashKey, View view, ArrayList arrayList, int[] nArray, ArrayList arrayList2) {
        int n3 = this.children.size();
        if (this.source.isLive()) {
            for (int i2 = 0; i2 < n3; ++i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained instanceof LeafRetained) {
                    if (nodeRetained instanceof LinkRetained) {
                        int n4 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        nArray = linkRetained.sharedGroup.processViewSpecificInfo(n2, hashKey.append("+").append(linkRetained.nodeId), view, arrayList, nArray, arrayList2);
                        hashKey.count = n4;
                        continue;
                    }
                    ((LeafRetained)nodeRetained).getMirrorObjects(arrayList2, hashKey);
                    continue;
                }
                nArray = nodeRetained.processViewSpecificInfo(n2, hashKey, view, arrayList, nArray, arrayList2);
            }
        }
        return nArray;
    }

    void findSwitchInfo(SetLiveState setLiveState, NodeRetained nodeRetained, NodeRetained nodeRetained2, NodeRetained nodeRetained3) {
        block14: {
            int n2;
            block13: {
                this.parentSwitchLinkChildIndex = -1;
                if (this.inSharedGroup) break block13;
                NodeRetained nodeRetained4 = nodeRetained3 == null ? nodeRetained2 : nodeRetained3;
                NodeRetained nodeRetained5 = nodeRetained;
                while (nodeRetained5 != null) {
                    if (nodeRetained5 instanceof SwitchRetained) {
                        setLiveState.switchLevels[0] = setLiveState.switchLevels[0] + 1;
                        if (setLiveState.closestSwitchParents[0] == null) {
                            setLiveState.closestSwitchParents[0] = (SwitchRetained)nodeRetained5;
                            ++((SwitchRetained)nodeRetained5).switchIndexCount;
                        }
                        if (this.parentSwitchLinkChildIndex == -1) {
                            this.parentSwitchLinkChildIndex = ((GroupRetained)nodeRetained5).children.indexOf(nodeRetained4);
                        }
                    } else if (nodeRetained5 instanceof SharedGroupRetained && this.parentSwitchLinkChildIndex == -1) {
                        this.parentSwitchLinkChildIndex = ((GroupRetained)nodeRetained5).children.indexOf(nodeRetained4);
                    }
                    nodeRetained4 = nodeRetained5;
                    nodeRetained5 = nodeRetained4.parent;
                }
                break block14;
            }
            setLiveState.switchLevels = new int[this.localToVworldKeys.length];
            setLiveState.closestSwitchParents = new SwitchRetained[this.localToVworldKeys.length];
            setLiveState.closestSwitchIndices = new int[this.localToVworldKeys.length];
            for (n2 = 0; n2 < this.localToVworldKeys.length; ++n2) {
                setLiveState.switchLevels[n2] = -1;
                setLiveState.closestSwitchParents[n2] = null;
                setLiveState.closestSwitchIndices[n2] = -1;
            }
            for (n2 = 0; n2 < this.localToVworldKeys.length; ++n2) {
                NodeRetained nodeRetained6 = nodeRetained3 == null ? nodeRetained2 : nodeRetained3;
                NodeRetained nodeRetained7 = nodeRetained;
                HashKey hashKey = new HashKey(this.localToVworldKeys[n2]);
                while (nodeRetained7 != null) {
                    block16: {
                        block15: {
                            if (!(nodeRetained7 instanceof SwitchRetained)) break block15;
                            int n3 = n2;
                            setLiveState.switchLevels[n3] = setLiveState.switchLevels[n3] + 1;
                            if (setLiveState.closestSwitchParents[n2] == null) {
                                setLiveState.closestSwitchParents[n2] = (SwitchRetained)nodeRetained7;
                                ++((SwitchRetained)nodeRetained7).switchIndexCount;
                            }
                            if (this.parentSwitchLinkChildIndex != -1) break block16;
                            this.parentSwitchLinkChildIndex = ((GroupRetained)nodeRetained7).children.indexOf(nodeRetained6);
                            break block16;
                        }
                        if (nodeRetained7 instanceof SharedGroupRetained) {
                            String string = hashKey.getLastNodeId();
                            Vector vector = ((SharedGroupRetained)nodeRetained7).parents;
                            if (this.parentSwitchLinkChildIndex == -1) {
                                this.parentSwitchLinkChildIndex = ((GroupRetained)nodeRetained7).children.indexOf(nodeRetained6);
                            }
                            for (int i2 = 0; i2 < vector.size(); ++i2) {
                                NodeRetained nodeRetained8 = (NodeRetained)vector.get(i2);
                                if (!nodeRetained8.nodeId.equals(string)) continue;
                                nodeRetained7 = nodeRetained8;
                                break;
                            }
                        }
                    }
                    nodeRetained6 = nodeRetained7;
                    nodeRetained7 = nodeRetained6.parent;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void gatherBlUsers(ArrayList arrayList, Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ArrayList arrayList2;
            ArrayList arrayList3 = arrayList2 = ((BoundingLeafRetained)objectArray[i2]).users;
            synchronized (arrayList3) {
                arrayList.addAll(arrayList2);
                continue;
            }
        }
    }

    void searchGeometryAtoms(UnorderList unorderList) {
        for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
            nodeRetained.searchGeometryAtoms(unorderList);
        }
    }
}

